.H 1 "Breakpoint Window"
This window displays a program's breakpoints.
This includes breakpoints, conditional breakpoints,
and tracepoints that have been set in Assembler and Source Text windows.
The menu bar allows all the breakpoints to be removed with
a single menu selection.
The line menu for each breakpoint allows the breakpoint to be removed,
or the source statement or machine instruction where the breakpoint was
set to be selected.
The window can be opened from the "Breakpoints" entry in the Process
window's "views" menu, and is opened automatically if an error occurs
while attempting to set a breakpoint in a program.
The window cannot be created when core dumps are examined.
.P
Since breakpoints may be removed with the "clr bpt" entry in the
line menus of Assembler and Source Text windows,
the Breakpoint window is used infrequently.
However, the window provides the most efficient way to remove a large
number of breakpoints and is useful if you can't remember
where the breakpoints were placed.
.P
The format used to display breakpoints in the Breakpoint window is compatible
the Process window's keyboard language,
allowing the breakpoints to be saved into a file and read back in later.
This feature may be used to copy a complicated set of breakpoints between
two different instances of the same program.
See "Process Keyboard".
.H 2 "Breakpoint Layout"
The title bar identifies the window and lists the process id number.
Each line displays a breakpoint, tracepoint or conditional breakpoint,
and is in one of two formats:
.DS I N
file:linenumber [condition]
pc=address
.DE
.P
The "file:lineumber" format is used for breakpoints set in Source Text windows.
With conditional breakpoints, the condition
is the expression evaluated each time the breakpoint is hit.
For tracepoints the condition is 0.
Breakpoints set in the Assembler window use the "pc=address" format
and display the instruction address as a decimal number.
The breakpoints are listed in the order they were set.
.H 2 "Breakpoint Menu Bar"
The "bpts" menu has the following entries:
.VL 13 1
.LI "clear all"
Remove all breakpoints from the process.
A pop-up window will ask you to confirm this choice before it is executed.
.LI "clean list"
Redisplay the lines in the window.
This is only needed if an error occurred while trying to set a breakpoint.
For example, if you set a breakpoint at a statement in a Source Text window,
and then disassemble the statement and try to set a
breakpoint at the statement's first instruction from the Assembler window,
an error occurs because you are attempting to set two different breakpoints
at the same instruction.
If this happens, the line displaying the original breakpoint
changes to an error message such as:
.DS I N
test1.c:20 same location as pc=8982
.DE
.P
and "clean list" removes the error message.
.LE
.H 2 "Breakpoint Line Menus"
.VL 12 1
.LI "clear bpt"
Remove the breakpoint.
If the Source Text or Assembler window that contains the line
where the breakpoint was set is open, that window and line are
selected after the breakpoint is removed.
.LI "src text"
Open the Source Text window and select the statement at the
location of the breakpoint. 
This entry is present if the breakpoint was set
from the Assembler window, i.e. lines in the window that are in
the format "pc=address".
.LI "assembler"
Open the Assembler window and disassemble the instruction at the location
of the breakpoint.
If the process is stopped, the original statement is displayed.
If the process is running, the instruction implementing the breakpoint
is displayed. 
.LE
